// --------------------------------------------------------------------
// Copyright (c) 2005 by Terasic Technologies Inc. 
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development 
//   Kits made by Terasic.  Other use of this code, including the selling 
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use 
//   or functionality of this code.
//
// --------------------------------------------------------------------
//           
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------
//
// Major Functions:	DE2 LTM module Timing control and output image data
//					form sdram 
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            		:| Mod. Date :| Changes Made:
//   V1.0 :| Johnny Fan				:| 07/06/30  :| Initial Revision
// --------------------------------------------------------------------
module lcd_timing_controller		(
						iCLK, 				// LCD display clock
						iRST_n, 			// systen reset
						// SDRAM SIDE 
						iREAD_DATA1, 		// R and G  color data form sdram 	
						iREAD_DATA2,		// B color data form sdram
						oREAD_SDRAM_EN,		// read sdram data control signal
						//LCD SIDE
						oHD,				// LCD Horizontal sync 
						oVD,				// LCD Vertical sync 	
						oDEN,				// LCD Data Enable
						oLCD_R,				// LCD Red color data 
						oLCD_G,             // LCD Green color data  
						oLCD_B,             // LCD Blue color data  
						
						
                        pio_racket_left,
                        pio_racket_right,
                        pio_pingpang,
                        pio_hex
						);
						

input [31:0]pio_racket_left;
input [31:0]pio_racket_right;
input [31:0]pio_pingpang;
input [15:0]pio_hex;
//============================================================================
// PARAMETER declarations
//============================================================================
parameter H_LINE = 1056;
parameter V_LINE = 525;
parameter Hsync_Blank = 216;
parameter Hsync_Front_Porch = 40;
parameter Vertical_Back_Porch = 35;
parameter Vertical_Front_Porch = 10;
//===========================================================================
// PORT declarations
//===========================================================================
input			iCLK;   
input			iRST_n;
input	[15:0]	iREAD_DATA1;
input	[15:0]	iREAD_DATA2;
output			oREAD_SDRAM_EN;
output	[7:0]	oLCD_R;		
output  [7:0]	oLCD_G;
output  [7:0]	oLCD_B;
output			oHD;
output			oVD;
output			oDEN;
//=============================================================================
// REG/WIRE declarations
//=============================================================================
reg		[10:0]  x_cnt;  
reg		[9:0]	y_cnt; 
wire	[7:0]	read_red;
wire	[7:0]	read_green;
wire	[7:0]	read_blue; 
wire			display_area;
wire			oREAD_SDRAM_EN;
reg				mhd;
reg				mvd;
reg				oHD;
reg				oVD;
reg				oDEN;
reg		[7:0]	oLCD_R;
reg		[7:0]	oLCD_G;	
reg		[7:0]	oLCD_B;		
//=============================================================================
// Structural coding
//=============================================================================

// This signal control reading data form SDRAM , if high read color data form sdram  .
assign	oREAD_SDRAM_EN = (	(x_cnt>Hsync_Blank-2)&&
							(x_cnt<(H_LINE-Hsync_Front_Porch-1))&&
							(y_cnt>(Vertical_Back_Porch-1))&&
							(y_cnt<(V_LINE - Vertical_Front_Porch))
						 )?  1'b1 : 1'b0;
						
// This signal indicate the lcd display area .
assign	display_area = ((x_cnt>(Hsync_Blank-1)&& //>215
						(x_cnt<(H_LINE-Hsync_Front_Porch))&& //< 1016
						(y_cnt>(Vertical_Back_Porch-1))&& 
						(y_cnt<(V_LINE - Vertical_Front_Porch))
						))  ? 1'b1 : 1'b0;
						
		


/*******************pingpong*******************************************/
wire [10:0]x_cord_pong;
wire [9:0]y_cord_pong;
assign x_cord_pong=pio_pingpang[10:0]+215;//11'd400;
assign y_cord_pong=pio_pingpang[20:11]+35;//10'd150; 				
						
wire en_pong;

assign en_pong=((x_cnt>=x_cord_pong) && (x_cnt<=x_cord_pong+30) && (y_cnt>=y_cord_pong)&&(y_cnt<=y_cord_pong+30))?1'b1:1'b0;


wire [9:0]addr_pong;

assign addr_pong=(x_cnt-x_cord_pong)+(y_cnt-y_cord_pong)*30;

wire [7:0]red_pong;


rom_pong  ii (
			.address(addr_pong),
			.clock(iCLK),
			.q(red_pong)
			);
			
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/***********************************************score1******************************************************************/
	
wire [10:0]x_cord_score1;
wire [9:0]y_cord_score1;
assign x_cord_score1=11'd520;
assign y_cord_score1=10'd50; 				
						
wire en_score1;

assign en_score1=((x_cnt>=x_cord_score1) && (x_cnt<=x_cord_score1+20) && (y_cnt>=y_cord_score1)&&(y_cnt<=y_cord_score1+20))?1'b1:1'b0;


wire [9:0]addr_score1;

assign addr_score1=(x_cnt-x_cord_score1)+(y_cnt-y_cord_score1)*20;


/*****************************score2*******************************************/

wire [10:0]x_cord_score2;
wire [9:0]y_cord_score2;
assign x_cord_score2=11'd540;
assign y_cord_score2=10'd50; 				
						
wire en_score2;

assign en_score2=((x_cnt>=x_cord_score2) && (x_cnt<=x_cord_score2+20) && (y_cnt>=y_cord_score2)&&(y_cnt<=y_cord_score2+20))?1'b1:1'b0;


wire [9:0]addr_score2;

assign addr_score2=(x_cnt-x_cord_score2)+(y_cnt-y_cord_score2)*20;


/*****************************score3*******************************************/

wire [10:0]x_cord_score3;
wire [9:0]y_cord_score3;
assign x_cord_score3=11'd600;
assign y_cord_score3=10'd50; 				
						
wire en_score3;

assign en_score3=((x_cnt>=x_cord_score3) && (x_cnt<=x_cord_score3+20) && (y_cnt>=y_cord_score3)&&(y_cnt<=y_cord_score3+20))?1'b1:1'b0;


wire [9:0]addr_score3;

assign addr_score3=(x_cnt-x_cord_score3)+(y_cnt-y_cord_score3)*20;



/*****************************score4*******************************************/

wire [10:0]x_cord_score4;
wire [9:0]y_cord_score4;
assign x_cord_score4=11'd620;
assign y_cord_score4=10'd50; 				
						
wire en_score4;

assign en_score4=((x_cnt>=x_cord_score4) && (x_cnt<=x_cord_score4+20) && (y_cnt>=y_cord_score4)&&(y_cnt<=y_cord_score4+20))?1'b1:1'b0;


wire [9:0]addr_score4;

assign addr_score4=(x_cnt-x_cord_score4)+(y_cnt-y_cord_score4)*20;


wire [15:0]HEX;
assign HEX=pio_hex;//16'H1234;

reg [9:0]addr_score;
reg   [3:0]num;

reg en_score;
always @(*)
     if (en_score1)
         begin
             addr_score<=addr_score1;
             en_score<=1;
             num<=HEX[3:0];
         end 
    else if (en_score2)
           begin 
             addr_score<=addr_score2;
             en_score<=1;
             num<=HEX[7:4];
            end 
    else if (en_score3)
             begin 
             addr_score<=addr_score3;
             en_score<=1;
             num<=HEX[11:8];
             end 
    else if (en_score4)
             begin 
             addr_score<=addr_score4;
             en_score<=1;
             num<=HEX[15:12];
             end 
    
    else 
          begin 
         addr_score<=0;
          en_score<=0;
          end
      
 
 wire [7:0]reg_score;
	  

 
choose_display ii3(
                     . clk(iCLK),
                      .rstn(iRST_n),

                      .num(num),
                      .addr(addr_score),

                      .data_out(reg_score)
                     );



	
	
	/************************************************racket*****************************************/
	/*******************racket*******************************************/
wire [10:0]x_cord_racket1;
wire [9:0]y_cord_racket1;
assign x_cord_racket1=pio_racket_left[10:0]+215;//11'd300;
assign y_cord_racket1=pio_racket_left[20:11]+35;//10'd150; 				
						
wire en_racket1;

assign en_racket1=((x_cnt>=x_cord_racket1) && (x_cnt<=x_cord_racket1+50) && (y_cnt>=y_cord_racket1)&&(y_cnt<=y_cord_racket1+50))?1'b1:1'b0;


wire [14:0]addr_racket1;

assign addr_racket1=(x_cnt-x_cord_racket1)+(y_cnt-y_cord_racket1)*50;

wire [10:0]x_cord_racket2;
wire [9:0]y_cord_racket2;
assign x_cord_racket2=pio_racket_right[10:0]+215;//11'd800;
assign y_cord_racket2=pio_racket_right[20:11]+35;//10'd150; 				
						
wire en_racket2;

assign en_racket2=((x_cnt>=x_cord_racket2) && (x_cnt<=x_cord_racket2+50) && (y_cnt>=y_cord_racket2)&&(y_cnt<=y_cord_racket2+50))?1'b1:1'b0;


wire [14:0]addr_racket2;

assign addr_racket2=(x_cnt-x_cord_racket2)+(y_cnt-y_cord_racket2)*50;


wire en_racket=en_racket1 | en_racket2;

reg [14:0]addr_racket;
always @(*)
   if (en_racket1)
       addr_racket<=addr_racket1;
   else 
       addr_racket<=addr_racket2;


wire [14:0]red_racket;


qiupai_rom i14(
		.address(addr_racket),
		.clock(iCLK),
		.q(red_racket)
		);

	
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////


assign	read_red 	= display_area ?( en_pong ?red_pong:(en_score?(reg_score+iREAD_DATA1[15:8]):(en_racket?(iREAD_DATA1[15:8] | red_racket):iREAD_DATA1[15:8] ))): 8'b0;
assign	read_green 	= display_area ?(en_score?(reg_score | iREAD_DATA1[7:0]):( en_racket?(iREAD_DATA1[7:0] | red_racket):iREAD_DATA1[7:0])): 8'b0;
assign	read_blue 	= display_area ?(en_score?(reg_score | iREAD_DATA2[7:0]):(en_racket?(iREAD_DATA2[7:0] | red_racket):iREAD_DATA2[7:0])): 8'b0;

///////////////////////// x  y counter  and lcd hd generator //////////////////
always@(posedge iCLK or negedge iRST_n)
	begin
		if (!iRST_n)
		begin
			x_cnt <= 11'd0;	
			mhd  <= 1'd0;  	
		end	
		else if (x_cnt == (H_LINE-1))
		begin
			x_cnt <= 11'd0;
			mhd  <= 1'd0;
		end	   
		else
		begin
			x_cnt <= x_cnt + 11'd1;
			mhd  <= 1'd1;
		end	
	end

always@(posedge iCLK or negedge iRST_n)
	begin
		if (!iRST_n)
			y_cnt <= 10'd0;
		else if (x_cnt == (H_LINE-1))
		begin
			if (y_cnt == (V_LINE-1))
				y_cnt <= 10'd0;
			else
				y_cnt <= y_cnt + 10'd1;	
		end
	end
////////////////////////////// touch panel timing //////////////////

always@(posedge iCLK  or negedge iRST_n)
	begin
		if (!iRST_n)
			mvd  <= 1'b1;
		else if (y_cnt == 10'd0)
			mvd  <= 1'b0;
		else
			mvd  <= 1'b1;
	end			


always@(posedge iCLK or negedge iRST_n)
	begin
		if (!iRST_n)
			begin
				oHD	<= 1'd0;
				oVD	<= 1'd0;
				oDEN <= 1'd0;
				oLCD_R <= 8'd0;
				oLCD_G <= 8'd0;
				oLCD_B <= 8'd0;
			end
		else
			begin
				oHD	<= mhd;
				oVD	<= mvd;
				oDEN <= display_area;
				oLCD_R <= read_red;
				oLCD_G <= read_green;
				oLCD_B <= read_blue;
			end		
	end
						
endmodule











